/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.dsl.RelationalMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.RelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelation;
import org.codefilarete.stalactite.engine.configurer.embeddable.Inset;
import org.codefilarete.stalactite.engine.configurer.manyToOne.ManyToOneRelation;
import org.codefilarete.stalactite.engine.configurer.manytomany.ManyToManyRelation;
import org.codefilarete.stalactite.engine.configurer.map.MapRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.tool.collection.Iterables;

public class RelationsStep<C, I> {
    void configureRelations(SimpleRelationalEntityPersister<C, I, ?> mainPersister, InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable, PersisterBuilderContext persisterBuilderContext, NamingConfiguration namingConfiguration, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        RelationConfigurer relationConfigurer = new RelationConfigurer(dialect, connectionConfiguration, mainPersister, namingConfiguration, persisterBuilderContext);
        persisterBuilderContext.runInContext(mainPersister, () -> {
            this.configuredInheritedRelations(inheritanceMappingPerTable, relationConfigurer);
            this.configuredEmbeddableRelations(inheritanceMappingPerTable, relationConfigurer, mainPersister.getClassToPersist());
        });
    }

    private void configuredInheritedRelations(InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable, RelationConfigurer<C, I> relationConfigurer) {
        inheritanceMappingPerTable.getMappings().stream().map(InheritanceMappingStep.Mapping::getMappingConfiguration).filter(RelationalMappingConfiguration.class::isInstance).map(RelationalMappingConfiguration.class::cast).forEach(relationConfigurer::configureRelations);
    }

    private <D> void configuredEmbeddableRelations(InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable, RelationConfigurer<C, I> relationConfigurer, Class<C> rootEntityType) {
        inheritanceMappingPerTable.getMappings().stream().map(InheritanceMappingStep.Mapping::getMappingConfiguration).filter(EntityMappingConfiguration.class::isInstance).map(EntityMappingConfiguration.class::cast).map(EntityMappingConfiguration::getPropertiesMapping).flatMap(conf -> conf.getInsets().stream().flatMap(inset -> Iterables.stream(inset.getConfigurationProvider().getConfiguration().inheritanceIterable()).map(confInHierarchy -> new ShiftedRelationalMappingConfiguration(rootEntityType, confInHierarchy, inset)))).forEach(shiftedRelationalMappingConfiguration -> relationConfigurer.configureRelations((RelationalMappingConfiguration)shiftedRelationalMappingConfiguration));
    }

    private class ShiftedRelationalMappingConfiguration<D>
    implements RelationalMappingConfiguration<C> {
        private final Class<C> rootEntityType;
        private final RelationalMappingConfiguration<D> configuration;
        private final Inset<C, D> inset;

        public ShiftedRelationalMappingConfiguration(Class<C> rootEntityType, RelationalMappingConfiguration<D> configuration, Inset<C, D> inset) {
            this.rootEntityType = rootEntityType;
            this.configuration = configuration;
            this.inset = inset;
        }

        @Override
        public Class<C> getEntityType() {
            return this.rootEntityType;
        }

        @Override
        public <TRGT, TRGTID> List<OneToOneRelation<C, TRGT, TRGTID>> getOneToOnes() {
            return this.configuration.getOneToOnes().stream().map(oneToOne -> oneToOne.embedInto(this.inset.getAccessor())).collect(Collectors.toList());
        }

        @Override
        public <TRGT, TRGTID> List<OneToManyRelation<C, TRGT, TRGTID, Collection<TRGT>>> getOneToManys() {
            return this.configuration.getOneToManys().stream().map(oneToMany -> oneToMany.embedInto(this.inset.getAccessor(), this.configuration.getEntityType())).collect(Collectors.toList());
        }

        @Override
        public <TRGT, TRGTID> List<ManyToManyRelation<C, TRGT, TRGTID, Collection<TRGT>, Collection<C>>> getManyToManys() {
            return this.configuration.getManyToManys().stream().map(manyToMany -> manyToMany.embedInto(this.inset.getAccessor(), this.configuration.getEntityType())).collect(Collectors.toList());
        }

        @Override
        public <TRGT, TRGTID> List<ManyToOneRelation<C, TRGT, TRGTID, Collection<C>>> getManyToOnes() {
            return this.configuration.getManyToOnes().stream().map(manyToOne -> manyToOne.embedInto(this.inset.getAccessor())).collect(Collectors.toList());
        }

        @Override
        public <TRGT> List<ElementCollectionRelation<C, TRGT, ? extends Collection<TRGT>>> getElementCollections() {
            return this.configuration.getElementCollections().stream().map(collectionRelation -> collectionRelation.embedInto(this.inset.getAccessor(), this.configuration.getEntityType())).collect(Collectors.toList());
        }

        @Override
        public List<MapRelation<C, ?, ?, ? extends Map>> getMaps() {
            return Collections.emptyList();
        }
    }
}

